package com.surpuissant.weather2

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import okhttp3.OkHttpClient

class RawWeatherViewModelFactory(
    private val okHttpClient: OkHttpClient
): ViewModelProvider.Factory {

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        val repository = WeatherRepository(okHttpClient)
        @Suppress("UNCHECKED_CAST")
        return WeatherViewModel(repository) as T
    }


}