package com.surpuissant.weather2

import com.surpuissant.weather2.MainActivity.MoshiProvider.moshi
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import okhttp3.OkHttpClient
import okhttp3.Request

const val OPEN_WEATHER_API_KEY = "a5b1bbe20012d67bc47feb5463e2ea9a"

class WeatherRepository(
    private val client: OkHttpClient,
) {

    suspend fun fetchWeather(city: String): ForecastModel = withContext(Dispatchers.IO) {
        val request = Request.Builder()
            .url("https://api.openweathermap.org/data/2.5/weather?q=$city&appid=$OPEN_WEATHER_API_KEY&units=metric&lang=fr")
            .build()

        client.newCall(request).execute().use { response ->
            if(!response.isSuccessful) error("Error HTTP: ${response.code}")
            val adapter = moshi.adapter(ForecastModel::class.java)
            adapter.fromJson(response.body.string()) ?: error("Json invalide")
        }
    }



}