package com.surpuissant.weather2

import android.util.Log
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

class WeatherViewModel(private val repository: WeatherRepository): ViewModel() {

    private val _preview = MutableStateFlow<ForecastModel?>(null)
    val preview: StateFlow<ForecastModel?> = _preview

    fun refresh(city: String, onDone: () -> Unit = {}) {
        viewModelScope.launch {
            runCatching { repository.fetchWeather(city) }
                .onFailure { error ->
                    Log.e("MyApp", "Error: ${error.message}")
                    onDone()
                }
                .onSuccess {
                    forecastModel -> _preview.value = forecastModel
                    onDone()
                }
        }
    }
}